#ifndef ANIMATION_DATA_H_
#define ANIMATION_DATA_H_

#include "vobject.h"

#include "Soldier Control.h"
#include "Overhead.h"
#include "Structure Internals.h"


// DEFINES FOR ANIMATION PROFILES
#define		TILE_FLAG_FEET					0x0001
#define		TILE_FLAG_MID						0x0002
#define		TILE_FLAG_HEAD					0x0004
#define		TILE_FLAG_CANMOVE				0x0008
#define		TILE_FLAG_NORTH_HALF		0x0010
#define		TILE_FLAG_SOUTH_HALF		0x0020
#define		TILE_FLAG_WEST_HALF			0x0040
#define		TILE_FLAG_EAST_HALF			0x0080
#define		TILE_FLAG_TOP_HALF			0x0100
#define		TILE_FLAG_BOTTOM_HALF		0x0200

#define		ANIM_DATA_FLAG_NOFRAMES	0x01

// ENUMERATIONS

// BODY TYPES
// RGM = Regular Male
// (RG) = Body desc ( Regular - RG, Short Stocky ( SS ), etc
// (M) = Sex, Male, female
#define	IS_MERC_BODY_TYPE( p )   ( ( p->ubBodyType <= REGFEMALE ) ? ( TRUE ) : ( FALSE ) )
#define IS_CIV_BODY_TYPE( p ) ( (p->ubBodyType >= FATCIV) && (p->ubBodyType <= CRIPPLECIV) )

#define NUMSOLDIERBODYTYPES	4
// marke strogg 1/x new bodytype
enum SoldierBodyTypes
{
	REGMALE = 0,
	BIGMALE,
	STOCKYMALE,
	REGFEMALE,
	ADULTFEMALEMONSTER,
	AM_MONSTER,
	YAF_MONSTER,
	YAM_MONSTER,
	LARVAE_MONSTER,
	INFANT_MONSTER,
	QUEENMONSTER,
	FATCIV,
	MANCIV,
	MINICIV,
	DRESSCIV,
	HATKIDCIV,
	KIDCIV,
	CRIPPLECIV,

	COW,
	CROW,
	BLOODCAT,

	ROBOTNOWEAPON,

	HUMVEE,
	TANK_NW,
	TANK_NE,
	ELDORADO,
	ICECREAMTRUCK,
	JEEP,
	STROGG_INF,
	STROGG_TANK,
	STROGG_TANK_COMMANDER,
	STROGG_GUNNER,
	STROGG_BERSERK,
	STROGG_GLADIATOR,
	STROGG_BRAIN,
	STROGG_CHICK,
	STROGG_MEDIC,
	STROGG_ICARUS,
	STROGG_FLYER,
	STROGG_LIGHT_GUARD,
	STROGG_SHOTGUN_GUARD,
	STROGG_MACHINEGUN_GUARD,
	ALIEN_EGG,
	ALIEN_HUGGER,
	ALIEN_BURSTER,
	ALIEN_DRONE,
	ALIEN_PRET,
	ALIEN_QUEEN,
	VICTIM_MALE,
	VICTIM_FEMALE,	

  TOTALBODYTYPES

} ;


// Enumerations
// This enumeration defines the graphic image file per animation

// RGM = Regular Male
// (RG) = Body desc ( Regular - RG, Short Stocky ( SS ), etc
// (M) = Sex, Male, female
typedef enum
{
	RGMBASICWALKING = 0,
	RGMSTANDING,
	RGMCROUCHING,
	RGMSNEAKING,
	RGMRUNNING,
	RGMPRONE,
	RGMSTANDAIM,
	RGMHITHARD,
	RGMHITSTAND,
	RGMHITHARDBLOOD,
	RGMCROUCHAIM,
	RGMHITFALLBACK,
	RGMROLLOVER,
	RGMCLIMBROOF,
	RGMFALL,
	RGMFALLF,
	RGMHITCROUCH,
	RGMHITPRONE,
	RGMHOPFENCE,
	RGMPUNCH,
	RGMNOTHING_STD,
	RGMNOTHING_WALK,
	RGMNOTHING_RUN,
	RGMNOTHING_SWAT,
	RGMNOTHING_CROUCH,
	RGMHANDGUN_S_SHOT,
	RGMHANDGUN_C_SHOT,
	RGMHANDGUN_PRONE,
	RGMDIE_JFK,
	RGMOPEN,
	RGMPICKUP,
	RGMSTAB,
	RGMSLICE,
	RGMCSTAB,
	RGMMEDIC,
	RGMDODGE,
	RGMSTANDDWALAIM,
	RGMRAISE,
	RGMTHROW,
	RGMLOB,
	RGMKICKDOOR,
	RGMRHIT,
	RGM_SQUISH,
	RGM_LOOK,
	RGM_PULL,
	RGM_SPIT,
	RGMWATER_R_WALK,
	RGMWATER_R_STD,
	RGMWATER_N_WALK,
	RGMWATER_N_STD,
	RGMWATER_DIE,
	RGMWATER_N_AIM,
	RGMWATER_R_AIM,
	RGMWATER_DBLSHT,
	RGMWATER_TRANS,
	RGMDEEPWATER_TRED,
	RGMDEEPWATER_SWIM,
	RGMDEEPWATER_DIE,
	RGMMCLIMB,
	RGMHELIDROP,
	RGMLOWKICK,
	RGMNPUNCH,
	RGMSPINKICK,
	RGMSLEEP,
	RGMSHOOT_LOW,
	RGMCDBLSHOT,
	RGMHURTSTANDINGN,
	RGMHURTSTANDINGR,
	RGMHURTWALKINGN,
	RGMHURTWALKINGR,	
	RGMHURTTRANS,
	RGMTHROWKNIFE,
	RGMBREATHKNIFE,
	RGMPISTOLBREATH,
	RGMCOWER,
	RGMROCKET,
	RGMMORTAR,
	RGMSIDESTEP,
	RGMDBLBREATH,
	RGMPUNCHLOW,
	RGMPISTOLSHOOTLOW,
	RGMWATERTHROW,
	RGMRADIO,
	RGMCRRADIO,
	RGMBURN,
	RGMDWPRONE,
	RGMDRUNK,
	RGMPISTOLDRUNK,
	RGMCROWBAR,
	RGMJUMPOVER,

	BGMWALKING,
	BGMSTANDING,
	BGMCROUCHING,
	BGMSNEAKING,
	BGMRUNNING,
	BGMPRONE,
	BGMSTANDAIM,
	BGMHITHARD,
	BGMHITSTAND,
	BGMHITHARDBLOOD,
	BGMCROUCHAIM,
	BGMHITFALLBACK,
	BGMROLLOVER,
	BGMCLIMBROOF,
	BGMFALL,
	BGMFALLF,
	BGMHITCROUCH,
	BGMHITPRONE,
	BGMHOPFENCE,
	BGMPUNCH,
	BGMNOTHING_STD,
	BGMNOTHING_WALK,
	BGMNOTHING_RUN,
	BGMNOTHING_SWAT,
	BGMNOTHING_CROUCH,
	BGMHANDGUN_S_SHOT,
	BGMHANDGUN_C_SHOT,
	BGMHANDGUN_PRONE,
	BGMDIE_JFK,
	BGMOPEN,
	BGMPICKUP,
	BGMSTAB,
	BGMSLICE,
	BGMCSTAB,
	BGMMEDIC,
	BGMDODGE,
	BGMSTANDDWALAIM,
	BGMRAISE,
	BGMTHROW,
	BGMLOB,
	BGMKICKDOOR,
	BGMRHIT,
	BGMSTANDAIM2,
	BGMFLEX,
	BGMSTRECH,
	BGMSHOEDUST,
	BGMHEADTURN,
	BGMWATER_R_WALK,
	BGMWATER_R_STD,
	BGMWATER_N_WALK,
	BGMWATER_N_STD,
	BGMWATER_DIE,
	BGMWATER_N_AIM,
	BGMWATER_R_AIM,
	BGMWATER_DBLSHT,
	BGMWATER_TRANS,
	BGMDEEPWATER_TRED,
	BGMDEEPWATER_SWIM,
	BGMDEEPWATER_DIE,
	BGMHELIDROP,
	BGMSLEEP,
	BGMSHOOT_LOW,
	BGMTHREATENSTAND,
	BGMCDBLSHOT,
	BGMHURTSTANDINGN,
	BGMHURTSTANDINGR,
	BGMHURTWALKINGN,
	BGMHURTWALKINGR,	
	BGMHURTTRANS,
	BGMTHROWKNIFE,
	BGMBREATHKNIFE,
	BGMPISTOLBREATH,
	BGMCOWER,
	BGMRAISE2,
	BGMROCKET,
	BGMMORTAR,
	BGMSIDESTEP,
	BGMDBLBREATH,
	BGMPUNCHLOW,
	BGMPISTOLSHOOTLOW,
	BGMWATERTHROW,
	BGMWALK2,
	BGMRUN2,
	BGMIDLENECK,
	BGMCROUCHTRANS,
	BGMRADIO,
	BGMCRRADIO,
	BGMDWPRONE,
	BGMDRUNK,
	BGMPISTOLDRUNK,
	BGMCROWBAR,
	BGMJUMPOVER,
	

	RGFWALKING,
	RGFSTANDING,
	RGFCROUCHING,
	RGFSNEAKING,
	RGFRUNNING,
	RGFPRONE,
	RGFSTANDAIM,
	RGFHITHARD,
	RGFHITSTAND,
	RGFHITHARDBLOOD,
	RGFCROUCHAIM,
	RGFHITFALLBACK,
	RGFROLLOVER,
	RGFCLIMBROOF,
	RGFFALL,
	RGFFALLF,
	RGFHITCROUCH,
	RGFHITPRONE,
	RGFHOPFENCE,
	RGFPUNCH,
	RGFNOTHING_STD,
	RGFNOTHING_WALK,
	RGFNOTHING_RUN,
	RGFNOTHING_SWAT,
	RGFNOTHING_CROUCH,
	RGFHANDGUN_S_SHOT,
	RGFHANDGUN_C_SHOT,
	RGFHANDGUN_PRONE,
	RGFDIE_JFK,
	RGFOPEN,
	RGFPICKUP,
	RGFSTAB,
	RGFSLICE,
	RGFCSTAB,
	RGFMEDIC,
	RGFDODGE,
	RGFSTANDDWALAIM,
	RGFRAISE,
	RGFTHROW,
	RGFLOB,
	RGFKICKDOOR,
	RGFRHIT,
	RGFCLEAN,
	RGFKICKSN,
	RGFALOOK,
	RGFWIPE,
	RGFWATER_R_WALK,
	RGFWATER_R_STD,
	RGFWATER_N_WALK,
	RGFWATER_N_STD,
	RGFWATER_DIE,
	RGFWATER_N_AIM,
	RGFWATER_R_AIM,
	RGFWATER_DBLSHT,
	RGFWATER_TRANS,
	RGFDEEPWATER_TRED,
	RGFDEEPWATER_SWIM,
	RGFDEEPWATER_DIE,
	RGFHELIDROP,
	RGFSLEEP,
	RGFSHOOT_LOW,
	RGFCDBLSHOT,
	RGFHURTSTANDINGN,
	RGFHURTSTANDINGR,
	RGFHURTWALKINGN,
	RGFHURTWALKINGR,	
	RGFHURTTRANS,
	RGFTHROWKNIFE,
	RGFBREATHKNIFE,
	RGFPISTOLBREATH,
	RGFCOWER,
	RGFROCKET,
	RGFMORTAR,
	RGFSIDESTEP,
	RGFDBLBREATH,
	RGFPUNCHLOW,
	RGFPISTOLSHOOTLOW,
	RGFWATERTHROW,
	RGFRADIO,
	RGFCRRADIO,
	RGFSLAP,
	RGFDWPRONE,
	RGFDRUNK,
	RGFPISTOLDRUNK,
	RGFCROWBAR,
	RGFJUMPOVER,

	AFMONSTERSTANDING,
	AFMONSTERWALKING,
	AFMONSTERATTACK,
	AFMONSTERCLOSEATTACK,
	AFMONSTERSPITATTACK,
	AFMONSTEREATING,
	AFMONSTERDIE,
	AFMUP,
	AFMJUMP,
	AFMMELT,

	LVBREATH,
	LVDIE,
	LVWALK,

	IBREATH,
	IWALK,
	IDIE,
	IEAT,
	IATTACK,

	QUEENMONSTERSTANDING,
	QUEENMONSTERREADY,
	QUEENMONSTERSPIT_SW,
	QUEENMONSTERSPIT_E,
	QUEENMONSTERSPIT_NE,
	QUEENMONSTERSPIT_S,
	QUEENMONSTERSPIT_SE,
	QUEENMONSTERDEATH,
	QUEENMONSTERSWIPE,

	FATMANSTANDING,
	FATMANWALKING,
	FATMANRUNNING,
	FATMANDIE,
	FATMANASS,
	FATMANACT,
	FATMANCOWER,
	FATMANDIE2,
	FATMANCOWERHIT,

	MANCIVSTANDING,
	MANCIVWALKING,
	MANCIVRUNNING,
	MANCIVDIE,
	MANCIVACT,
	MANCIVCOWER,
	MANCIVDIE2,
	MANCIVSMACKED,
	MANCIVPUNCH,
	MANCIVCOWERHIT,

	MINICIVSTANDING,
	MINICIVWALKING,
	MINICIVRUNNING,
	MINICIVDIE,
	MINISTOCKING,
	MINIACT,
	MINICOWER,
	MINIDIE2,
	MINICOWERHIT,

	DRESSCIVSTANDING,
	DRESSCIVWALKING,
	DRESSCIVRUNNING,
	DRESSCIVDIE,
	DRESSCIVACT,
	DRESSCIVCOWER,
	DRESSCIVDIE2,
	DRESSCIVCOWERHIT,

	HATKIDCIVSTANDING,
	HATKIDCIVWALKING,
	HATKIDCIVRUNNING,
	HATKIDCIVDIE,
	HATKIDCIVJFK,
	HATKIDCIVYOYO,
	HATKIDCIVACT,
	HATKIDCIVCOWER,
	HATKIDCIVDIE2,
	HATKIDCIVCOWERHIT,
	HATKIDCIVSKIP,

	KIDCIVSTANDING,
	KIDCIVWALKING,
	KIDCIVRUNNING,
	KIDCIVDIE,
	KIDCIVJFK,
	KIDCIVARMPIT,
	KIDCIVACT,
	KIDCIVCOWER,
	KIDCIVDIE2,
	KIDCIVCOWERHIT,
	KIDCIVSKIP,

	CRIPCIVSTANDING,
	CRIPCIVWALKING,
	CRIPCIVRUNNING,
	CRIPCIVBEG,
	CRIPCIVDIE,
	CRIPCIVDIE2,
	CRIPCIVKICK,

	COWSTANDING,
	COWWALKING,
	COWDIE,
	COWEAT,

	CROWWALKING,
	CROWFLYING,
	CROWEATING,
	CROWDYING,

	CATBREATH,
	CATWALK,
	CATRUN,
	CATREADY,
	CATHIT,
	CATDIE,
	CATSWIPE,
	CATBITE,

	ROBOTNWBREATH,
	ROBOTNWWALK,
	ROBOTNWHIT,
	ROBOTNWDIE,
	ROBOTNWSHOOT,

	HUMVEE_BASIC,
	HUMVEE_DIE,

	TANKNW_READY,
	TANKNW_SHOOT,
	TANKNW_DIE,

	TANKNE_READY,
	TANKNE_SHOOT,
	TANKNE_DIE,

	ELDORADO_BASIC,
	ELDORADO_DIE,

	ICECREAMTRUCK_BASIC,
	ICECREAMTRUCK_DIE,

	JEEP_BASIC,
	JEEP_DIE,

	BODYEXPLODE,
	INF_BREATHE,
	INF_DIE1,
	INF_DIE2,
	INF_FIRE1,
	INF_FIRE2,
	INF_PAIN,
	INF_RUN,
	INF_WALK,
	
	TANK_BREATHE,
	TANK_DIE,
	TANK_FIRE,
	TANK_PAIN,
	TANK_WALK,
	
	TANKC_BREATHE,
	TANKC_DIE,
	TANKC_FIRE,
	TANKC_PAIN,
	TANKC_WALK,
	
	GUN_BREATHE,
	GUN_DIE,
	GUN_FIRE,
	GUN_IDLE,
	GUN_PAIN,
	GUN_RUN,
	GUN_WALK,
	
	BERS_BREATHE,
	BERS_DIE,
	BERS_HAMMER,
	BERS_SPIKE,
	BERS_IDLE,
	BERS_RUN,
	BERS_WALK,
	
	GLAD_BREATHE,
	GLAD_CLAMB,
	GLAD_DIE,
	GLAD_PAIN,
	GLAD_RAIL,
	GLAD_RUN,
	GLAD_WALK,

	BRAIN_BREATHE,
	BRAIN_DIE,
	BRAIN_PAIN,
	BRAIN_SLICE,
	BRAIN_TENTAC,
	BRAIN_WALK,

	CHICK_BREATHE,
	CHICK_CLAW,
    CHICK_DIE,
	CHICK_IDLE,
	CHICK_PAIN,
	CHICK_ROCKET,
	CHICK_WALK,

	MEDIC_BREATHE,
	MEDIC_DIE,
	MEDIC_FIRE,
	MEDIC_PAIN,
	MEDIC_RUN,
	MEDIC_WALK,

	ICA_ALL,
	ICA_DIE,
	FLYER_ALL,

	LG_BREATHE,
	LG_DIE1AND4,
	LG_DIE2,
	LG_DIE3,
	LG_SHOT,
	LG_IDLE,
	LG_PAIN,
	LG_RUN,
	LG_WALK,

	SHG_BREATHE,
	SHG_DIE1AND4,
	SHG_DIE2,
	SHG_DIE3,
	SHG_SHOT,
	SHG_IDLE,
	SHG_PAIN,
	SHG_RUN,
	SHG_WALK,

	MGG_BREATHE,
	MGG_DIE1AND4,
	MGG_DIE2,
	MGG_DIE3,
	MGG_SHOT,
	MGG_IDLE,
	MGG_PAIN,
	MGG_RUN,
	MGG_WALK,
	EGG_ALL,
	HUGGER_ALL,
	BURSTER_ALL,
	DATT,
	DDIE,
	DPAIN,
	DRUN,
	DSTAND,
	PATT,
	PDIE,
	PPAIN,
	PRUN,
	PSTAND,
	QATTACK,
	QDIE,
	QMOVE,
	QPAIN,
	QTAUNT,
	MVICT_ALL,
	FVICT_ALL,	

	// marke strogg 2/x set ani names


	NUMANIMATIONSURFACETYPES

} AnimationSurfaceTypes;

// Enumerations for struct data
typedef enum
{
	S_STRUCT,
	C_STRUCT,
	P_STRUCT,
	F_STRUCT,
	FB_STRUCT,
	DEFAULT_STRUCT,
	NUM_STRUCT_IDS,
	NO_STRUCT = 120,
};

// Struct for animation 'surface' information
typedef struct
{
	UINT16								  ubName;
	CHAR8										Filename[ 50 ];
	CHAR8										bStructDataType; 
	UINT8										ubFlags;
	UINT32									uiNumDirections;
	UINT32									uiNumFramesPerDir;
	HVOBJECT								hVideoObject;
	void										*Unused;
	INT8										bUsageCount;
	INT8										bProfile;

} AnimationSurfaceType;


typedef struct
{
	CHAR8										Filename[ 50 ];
	STRUCTURE_FILE_REF *		pStructureFileRef;

} AnimationStructureType;
 
	
extern AnimationSurfaceType		gAnimSurfaceDatabase[ NUMANIMATIONSURFACETYPES ];
extern AnimationStructureType	gAnimStructureDatabase[ TOTALBODYTYPES ][ NUM_STRUCT_IDS ];


// Functions
BOOLEAN InitAnimationSystem( );
BOOLEAN DeInitAnimationSystem( );
BOOLEAN LoadAnimationSurface(  UINT16 usSoldierID, UINT16 usSurfaceIndex, UINT16 usAnimState );
BOOLEAN UnLoadAnimationSurface(  UINT16 usSoldierID, UINT16 usSurfaceIndex );
void ClearAnimationSurfacesUsageHistory( UINT16 usSoldierID );


void DeleteAnimationProfiles( );
BOOLEAN LoadAnimationProfiles( );

STRUCTURE_FILE_REF	*GetAnimationStructureRef( UINT16 usSoldierID, UINT16 usSurfaceIndex, UINT16 usAnimState );
STRUCTURE_FILE_REF	*GetDefaultStructureRef( UINT16 usSoldierID );

// Profile data
extern ANIM_PROF	*gpAnimProfiles;
extern UINT8		gubNumAnimProfiles;

void ZeroAnimSurfaceCounts( );

#endif
